/*
  
Rangines statistikos (order statistics) medis yra raudonai-juodas medis, kurio
kiekvienoje virsuneje saugoma papildoma informacija  pomedzio,
prasidedanioje toje virsuneje virsuniu skaiius. Rangines statistikos medio
pagrindu realizuoti algoritma, kuris duotiems skaiiams a ir b suranda visus x,
tokius kad a < x < b.

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <alloc.h>
#include <iostream>
#include <time.h>

using namespace std;

typedef int T; 
                 /* Tipas, ka desim */
#define compLT(a,b) (a < b)
#define compEQ(a,b) (a == b)

/* Aprasymas */
typedef enum { BLACK, RED } nodeColor;

typedef struct Node_ 
{
	struct Node_ *kaire;         
	struct Node_ *desine;        
	struct Node_ *tevas;     
	int count;
	nodeColor color;            /* spalva */
	T data;                     /* Duomenys */
} Node;

#define NIL &sentinel           
Node sentinel = { NIL, NIL, 0, 1, BLACK, 0};

Node *root = NIL;               /* pagrindinis elemtnas */

void printall(Node *x){
     if( x != NIL){
         printall(x->kaire);
         cout << "el: " << x->data << "\tcount: " << x->count << "\tSpalva: " << x->color << '\n';
         printall(x->desine);
     }
}


/*
void sel_el(int a, int b, Node *x){
     if( x != NIL ){
         if (x->count > a){
               sel_el(a, b,x->kaire);
         }
         if (x->count > a && x->count < b)
            cout << x->count << " ";
         
         if (x->count < b){
               sel_el(a, b,x->desine);
         }
     }
}
*/

void sel_el(int a, int b, Node *x){
     if( x != NIL ){
         sel_el(a, b,x->kaire);
         if (x->count > a && x->count < b)
            cout << x->count << " ";
         sel_el(a, b,x->desine);
     }
}
void verstkaire(Node *x) 
{
	/**************************
	*  Sukti i kaire*
	**************************/
	
	Node *y = x->desine;
	/* Nustatyti x>desine */
	x->desine = y->kaire;
	if (y->kaire != NIL) 
		  y->kaire->tevas = x;
	
	/* nustatyti y>desine teva */
	if (y != NIL) 
		  y->tevas = x->tevas;
    if (x->tevas) 
    {
  	   if (x == x->tevas->kaire)
           x->tevas->kaire = y;
       else
           x->tevas->desine = y;
     } 
     else 
     {
  	    root = y;
     }
      /* SUvedam x ir y */
      y->kaire = x;
      if (x != NIL) 
          x->tevas = y;
}

void verstdesine(Node *x) 
{
	/****************************
	*  Pasukam i desine  *
	****************************/
	
	Node *y = x->kaire;
	
      /* Nustatyti x>kaire */
	x->kaire = y->desine;
	if (y->desine != NIL) 
        y->desine->tevas = x;
	
	/* nustatyti y>kaire teva */
    if (y != NIL) 
  	    y->tevas = x->tevas;
    if (x->tevas) 
    {
  	    if (x == x->tevas->desine)
            x->tevas->desine = y;
        else
            x->tevas->kaire = y;
    } 
    else 
    {
  	    root = y;
    }
    y->desine = x;
    if (x != NIL) 
    x->tevas = y;
}

void insertFixup(Node *x) 
{
	/*************************************
	*  Subalansuoti medi po iterpimo    *
	*************************************/
	
	/* patikrinam esamus duomenis  */
	while (x != root && x->tevas->color == RED) 
	{
		/* negalima */
		if (x->tevas == x->tevas->tevas->kaire) 
		{
			Node *y = x->tevas->tevas->desine;
            if (y->color == RED) 
            {
      	        /* yra raudonas */
      	        x->tevas->color = BLACK;
      	        y->color = BLACK;
      	        x->tevas->tevas->color = RED;
      	        x = x->tevas->tevas;
            } 
            else 
            {
      	        /* juodas */
      	        if (x == x->tevas->desine) 
      	        {
      		        /* padaryti x kairiu vaiku */
      		        x = x->tevas;
      		        verstkaire(x);
                 }
                /* nuspalvonti ir pasukti */
                x->tevas->color = BLACK;
                x->tevas->tevas->color = RED;
                verstdesine(x->tevas->tevas);
            }
         } 
         else 
         {
              /* tas pat kaip ir pries tai, tik skirtinga puse */
              Node *y = x->tevas->tevas->kaire;
	          if (y->color == RED)
   		      {
                         
                           x->tevas->color = BLACK;
                           y->color = BLACK;
                           x->tevas->tevas->color = RED;
                           x = x->tevas->tevas;
              } 
              else 
              {
                   
                   if (x == x->tevas->kaire) 
                   {
                         x = x->tevas;
                         verstdesine(x);
                         }
                   x->tevas->color = BLACK;
                   x->tevas->tevas->color = RED;
                   verstkaire(x->tevas->tevas);
             }
         }
     }
     root->color = BLACK;
}

Node *idejimas(T data) 
{
     Node *current, *tevas, *x, *ret;
     /***********************************************
     *  surasti elementa iterpimui                 *
     ***********************************************/
	
    /* Surandam kur elementas priklauso  */
	current = root;
	tevas = 0;

	
    while (current != NIL) 
    {
          if (compEQ(data, current->data)){
              return (current);
          }
          tevas = current;
          current = compLT(data, current->data) ?
          current->kaire : current->desine;
    }
    /* naujo nustatymai  */
    x = (Node*)malloc(sizeof(*x));
    if (x == 0) 
    {
          cout << "insufficient memory (idejimas)";
          exit(1);
    }
    x->data = data;
    x->tevas = tevas;
    x->kaire = NIL;
    x->desine = NIL;
    x->color = RED;
    x->count = 0;
    /*  idejimas i medi  */
    if(tevas) 
    {
               if(compLT(data, tevas->data))
                    tevas->kaire = x;
               else
                    tevas->desine = x;
    } 
    else 
    {
         root = x;
    }
    insertFixup(x);
    return(x);
}

Node *findNode(T data) 
{
     /*******************************
     *  elemento suradimas  *
     *******************************/
     int xx;
     Node *current = root;
     xx=0;
     while(current != NIL)
     if(compEQ(data, current->data)) 
     {
        cout<< "Elemtas toks buvo \n"  ;
        return (current);
        
      }
     
     else
        current = compLT (data, current->data) ?
        current->kaire : current->desine;
        
     
     return(0);
}
void deleteFixup(Node *x) {

   /*************************************
    *  Atkuriam balansa, taip pat kaip ir su istryinimu  *
    *************************************/

    while (x != root && x->color == BLACK) {
        if (x == x->tevas->kaire) {
            Node *w = x->tevas->desine;
            if (w->color == RED) {
                w->color = BLACK;
                x->tevas->color = RED;
                verstkaire (x->tevas);
                w = x->tevas->desine;
            }
            if (w->kaire->color == BLACK && w->desine->color == BLACK) {
                w->color = RED;
                x = x->tevas;
            } else {
                if (w->desine->color == BLACK) {
                    w->kaire->color = BLACK;
                    w->color = RED;
                    verstdesine (w);
                    w = x->tevas->desine;
                }
                w->color = x->tevas->color;
                x->tevas->color = BLACK;
                w->desine->color = BLACK;
                verstkaire (x->tevas);
                x = root;
            }
        } else {
            Node *w = x->tevas->kaire;
            if (w->color == RED) {
                w->color = BLACK;
                x->tevas->color = RED;
                verstdesine (x->tevas);
                w = x->tevas->kaire;
            }
            if (w->desine->color == BLACK && w->kaire->color == BLACK) {
                w->color = RED;
                x = x->tevas;
            } else {
                if (w->kaire->color == BLACK) {
                    w->desine->color = BLACK;
                    w->color = RED;
                    verstkaire (w);
                    w = x->tevas->kaire;
                }
                w->color = x->tevas->color;
                x->tevas->color = BLACK;
                w->kaire->color = BLACK;
                verstdesine (x->tevas);
                x = root;
            }
        }
    }
    x->color = BLACK;
}

void trynimasElem(Node *z) {
    Node *x, *y;

   /*****************************
    * trinam Z ir medzio *
    *****************************/

    if (!z || z == NIL) return;


    if (z->kaire == NIL || z->desine == NIL) {
        /* y turi nil */
        y = z;
    } else {
        y = z->desine;
        while (y->kaire != NIL) y = y->kaire;
    }

    /* x yra vienintelis Y sunus */
    if (y->kaire != NIL)
        x = y->kaire;
    else
        x = y->desine;

    /* ismetam Y is tevo grandines */
    x->tevas = y->tevas;
    if (y->tevas)
        if (y == y->tevas->kaire)
            y->tevas->kaire = x;
        else
            y->tevas->desine = x;
    else
        root = x;

    if (y != z) z->data = y->data;


    if (y->color == BLACK)
        deleteFixup (x);

    free (y);
}
  void menu() {
      cout << "\n\n\n\t Pasirinkite viena is galimu veiksmu: \n\n\n"; 
	  cout << "\t 1 -medis\n\n";
	  cout << "\t 2 - ieskoti nario\n\n";
	  cout << "\t 3 - ismesti nari\n\n";
	  cout << "\t 4 - iterpti nari\n\n";
	  cout << "\t 5 - isvesti medi\n\n";
	  cout << "\t 6 - a ir b\n\n";
	  cout << "\t 7 - iseiti is programos\n\n\n";
	  cout << "\tJusu pasirinkimas: ";
}

void skaiciuoti(Node *t){
     Node * tmp;
     if (t != NIL){
          tmp = t;
          while ( tmp != NULL ){
                   (tmp->count)++;
                   tmp = tmp->tevas;
          }
          if( t->kaire != NIL)
              skaiciuoti(t->kaire);
          if( t->desine != NIL)
              skaiciuoti(t->desine);
     }
}

void trinti_nariu_sk(Node *t){
     if(t != NIL){
          t->count = 0;
          if( t->kaire != NIL)
              trinti_nariu_sk(t->kaire);
          if( t->desine != NIL)
              trinti_nariu_sk(t->desine);
     }
}

void skaiciuoti_narius(Node *t){
     trinti_nariu_sk(t);
     skaiciuoti(t);
}


int main() 
{   int input = 0, Sk;
    int a, maxnum, ct;
    Node *t;
    do {
		menu();
		cin >> input;
		cout << endl;
		
		if(input == 1)
       {
    cout << "Iveskite kokio dydzio medis" << endl;
    cin >>maxnum;
    cout << "Iveskite  medzio narius "<<endl; 
    
             for (ct = maxnum; ct; ct--) 
           {
                cin >> a ;
                idejimas(a);
           }
           skaiciuoti_narius(root);
           system("pause");
       }
       
        if(input == 2)
      { Sk=0;
     cout << "Iveskite ieskomaji nari :"<<endl;
     cin >> a ;
     for (ct = maxnum; ct; ct--) 
    {
      if ((t = findNode(a)) != NULL)Sk=1;
    }
        if(Sk!=0)
            cout << "Naris buvo rastas."<<endl;
         else cout << "Tokio nario nera."<<endl;
            system("pause");        
      }  
        
        if(input == 3)
        {  Sk=0; 
     cout << "Iveskite nari kuri reikia pasalinti ";   cin >> a;
     for (ct = maxnum ; ct ; ct--)
    {
         if ((t = findNode(a)) != NULL) 
           { trynimasElem(t);Sk=1;
             skaiciuoti_narius(root);
                   }
         }
        if (Sk!=0){ cout << "Naris buvo istrintas."<<endl;   }
        else
          { cout << "Tokio nario nera."<<endl;Sk=0;
          }
         system("pause");
        }
     if(input == 4){
     cout << "Iveskite koki nari norite iterpti" << endl;
                cin >> a ;
                idejimas(a);
                skaiciuoti_narius(root);
                system("pause");
      
    
    }

   if(input == 5)
     {
			printall(root);
      }
   if(input == 6)
     {
            int a, b;
            cout << "iveskite a ir b: ";
            cin >> a >> b;
			sel_el(a, b, root);
      }
   if(input == 7)
     {
			break;
      }
   }
	while(true);

    return 0;

}


